/*
 * @Description:5 * @Date: 2020-06-03 09:32:04
 * @Author: 吳星萍 iris@e-besthealth.com
 * @LastEditors: 吳星萍 iris@e-besthealth.com
 * @LastEditTime: 2020-06-19 11:16:29
 * @copyright: BEST HEALTH ELECTRONIC INC (c) 2019
 */
#include "common.h"
extern const unsigned int DebufInfo[IAPWRLENGHT];

void main()
{
	// 判斷是否為上電復位或者非正常情況下的復位
	// 如果是上電復位，執行上電復位初始化，反之執行WDT溢出初始化
	if (_to == 0 || _pdf ==0)
	{
		// System
		Drv_SysClockInit();
		Drv_RamInit();
		SET_WDTTIME_125MS();
		SET_LVR_1V9();

		//IAP demo
		unsigned char i;
		for ( i = 0; i <IAPWRLENGHT; i++)
		{
			Flash_WR_Buff[i] = 0x00;
		}
		
		// 1 TABLE READ 讀取FLASH ROM 資料
		for ( i = 0; i <IAPWRLENGHT; i++)
		{
			Flash_WR_Buff[i] = DebufInfo[i];	
		}

		
		// 2 BUF自加
		for ( i = 0; i <IAPWRLENGHT; i++)
		{
			Flash_WR_Buff[i]++;
			//Flash_WR_Buff[i] = 0x55AA;
		}

				
		// 3 IAP 寫FLASH ROM 資料
		if (!Drv_WriteFlashRom(IAPWRSTARTADDRESS,IAPWRLENGHT))
		{
			Drv_WriteFlashRom(IAPWRSTARTADDRESS,IAPWRLENGHT);
		}
		
		// 4 清除BUF
		for ( i = 0; i <IAPWRLENGHT; i++)
		{
			Flash_WR_Buff[i] = 0x00;
		}
		
		// 5 TABLE READ 讀取FLASH ROM 資料確認資料已經有寫入
		for ( i = 0; i <IAPWRLENGHT; i++)
		{
			Flash_WR_Buff[i] = Drv_ReadFlashRom(IAPWRSTARTADDRESS+i);
		}
		GCC_NOP();
	}
	else
	{
		// WDT溢出復位初始化
		GCC_CLRWDT();

	}
	//主循環
	while(1)
	{
		GCC_CLRWDT();

	}
}